
"""


Auteur: anonyme

Interface: microbit

Nom du projet: Télémètre

Description: No-description

Toolbox: vittascience

Mode: blocks

Blocks: <xml xmlns="https://developers.google.com/blockly/xml"><block type="on_start" id="G[=T#8yqB70`NFgYq}GP" deletable="false" x="-212" y="37"></block><block type="forever" id="o[WN]+eeF.OUxGch67@8" x="87" y="163"><statement name="DO"><block type="io_onButtonPressed" id="[a%HS|t)JG?$#+n5hvn;"><field name="BUTTON">a</field><field name="STATE">is_</field><statement name="DO"><block type="display_setNumberGrove4Digit" id="tiikS|`M4@neDM1p?Snf"><field name="SHOW">NUM</field><field name="CLK">pin2</field><field name="DIO">pin12</field><value name="N"><shadow type="math_number" id="Ha1ns7|I9{T[gNdaOZ?l"><field name="NUM">1024</field></shadow><block type="sensors_getGroveUltrasonicRanger" id="_,:3;D5@;eKwx4N[-TX*"><mutation pin="true"></mutation><field name="SENSOR">GROVE</field><field name="DATA">DIST</field><field name="PIN">pin1</field></block></value></block></statement></block></statement></block></xml>

Projet généré par Vittascience.

Ce fichier contient le code textuel ainsi que le code blocs. Il peut être importé de nouveau

sur l'interface http://vittascience.com/microbit


"""

from microbit import *
from machine import time_pulse_us
import utime
from tm1637 import TM1637

# Ultrasonic on pin1
# 4 Digit Display CLK on pin2
# 4 Digit Display DIO on pin12
tm1637_2 = TM1637(clk=pin2, dio=pin12)

def getUltrasonicData(trig, echo, data='distance', timeout_us=30000):
  trig.write_digital(0)
  utime.sleep_us(2)
  trig.write_digital(1)
  utime.sleep_us(10)
  trig.write_digital(0)
  echo.read_digital()
  duration = time_pulse_us(echo, 1, timeout_us)/1e6 # t_echo in seconds
  if duration > 0:
    if data == 'distance':
      #sound speed, round-trip/2, get in cm
      return 343 * duration/2 * 100
    elif data == 'duration':
      return duration
    else:
      raise ValueError("Data option '" + data + "' is not valid")
  else:
    return -1

while True:
  if button_a.is_pressed():
    tm1637_2.number(int(getUltrasonicData(pin1, pin1, 'distance')))
